<?php
if(!function_exists('buro_mikado_tabs_typography_styles')){
	function buro_mikado_tabs_typography_styles(){
		$selector = '.mkd-tabs .mkd-tabs-nav li a';
		$tabs_tipography_array = array();
		$font_family = buro_mikado_options()->getOptionValue('tabs_font_family');
		
		if(buro_mikado_is_font_option_valid($font_family)){
			$tabs_tipography_array['font-family'] = buro_mikado_get_font_option_val($font_family);
		}
		
		$text_transform = buro_mikado_options()->getOptionValue('tabs_text_transform');
        if(!empty($text_transform)) {
            $tabs_tipography_array['text-transform'] = $text_transform;
        }

        $font_style = buro_mikado_options()->getOptionValue('tabs_font_style');
        if(!empty($font_style)) {
            $tabs_tipography_array['font-style'] = $font_style;
        }

        $letter_spacing = buro_mikado_options()->getOptionValue('tabs_letter_spacing');
        if($letter_spacing !== '') {
            $tabs_tipography_array['letter-spacing'] = buro_mikado_filter_px($letter_spacing).'px';
        }

        $font_weight = buro_mikado_options()->getOptionValue('tabs_font_weight');
        if(!empty($font_weight)) {
            $tabs_tipography_array['font-weight'] = $font_weight;
        }

        echo buro_mikado_dynamic_css($selector, $tabs_tipography_array);
	}
	add_action('buro_mikado_style_dynamic', 'buro_mikado_tabs_typography_styles');
}

if(!function_exists('buro_mikado_tabs_inital_color_styles')){

	function buro_mikado_tabs_inital_color_styles(){
		$selector = '.mkd-tabs:not(.mkd-tab-boxed) .mkd-tabs-nav li a';
		$border_selector = '.mkd-tabs.mkd-horizontal-tab .mkd-tab-container,.mkd-tabs.mkd-vertical-tab .mkd-tabs-nav li a,.mkd-tabs.mkd-horizontal-tab .mkd-tabs-nav li a';

		$styles = array();
		
		if(buro_mikado_options()->getOptionValue('tabs_color')) {
            $styles['color'] = buro_mikado_options()->getOptionValue('tabs_color');
        }

		if(buro_mikado_options()->getOptionValue('tabs_border_color')) {
            echo buro_mikado_dynamic_css($border_selector,array(
            	'border-color' => buro_mikado_options()->getOptionValue('tabs_border_color')
            	)
            );
        }
		
		echo buro_mikado_dynamic_css($selector, $styles);
	}

	add_action('buro_mikado_style_dynamic', 'buro_mikado_tabs_inital_color_styles');
}

if(!function_exists('buro_mikado_tabs_active_color_styles')){

	function buro_mikado_tabs_active_color_styles(){
		$selector = array(
			'.mkd-tabs:not(.mkd-tab-boxed) .mkd-tabs-nav li.ui-state-active a',
			'.mkd-tabs:not(.mkd-tab-boxed) .mkd-tabs-nav li.ui-state-hover a'
		);
		$border_selector = array(
			'.mkd-tabs .mkd-tabs-nav li.ui-state-active:after',
			'.mkd-tabs .mkd-tabs-nav li.ui-state-hover:after'
		);

		$styles = array();
		
		if(buro_mikado_options()->getOptionValue('tabs_color_active')) {
            $styles['color'] = buro_mikado_options()->getOptionValue('tabs_color_active');
        }

		if(buro_mikado_options()->getOptionValue('tabs_border_color_active')) {
            echo buro_mikado_dynamic_css($border_selector,array(
            	'background-color' => buro_mikado_options()->getOptionValue('tabs_border_color_active')
            	)
            );
        }
		
		echo buro_mikado_dynamic_css($selector, $styles);
	}

	add_action('buro_mikado_style_dynamic', 'buro_mikado_tabs_active_color_styles');
}

if(!function_exists('buro_mikado_boxed_tabs_inital_color_styles')){

	function buro_mikado_boxed_tabs_inital_color_styles(){
		$selector = '.mkd-tabs.mkd-tab-boxed .mkd-tabs-nav li a';
		$styles = array();
		
		if(buro_mikado_options()->getOptionValue('boxed_tabs_color')) {
            $styles['color'] = buro_mikado_options()->getOptionValue('boxed_tabs_color');
        }

		if(buro_mikado_options()->getOptionValue('boxed_tabs_back_color')) {
            $styles['background-color'] = buro_mikado_options()->getOptionValue('boxed_tabs_back_color');
        }
		
		echo buro_mikado_dynamic_css($selector, $styles);
	}

	add_action('buro_mikado_style_dynamic', 'buro_mikado_boxed_tabs_inital_color_styles');
}
if(!function_exists('buro_mikado_tabs_boxed_active_color_styles')){

	function buro_mikado_tabs_boxed_active_color_styles(){
		$selector = array(
			'.mkd-tabs.mkd-tab-boxed .mkd-tabs-nav li.ui-state-active a',
			'.mkd-tabs.mkd-tab-boxed .mkd-tabs-nav li.ui-state-hover a'
		);

		$styles = array();
		
		if(buro_mikado_options()->getOptionValue('boxed_tabs_color_active')) {
            $styles['color'] = buro_mikado_options()->getOptionValue('boxed_tabs_color_active');
        }

		if(buro_mikado_options()->getOptionValue('boxed_tabs_back_color_active')) {
            $styles['background-color'] = buro_mikado_options()->getOptionValue('boxed_tabs_back_color_active');
        }
		
		echo buro_mikado_dynamic_css($selector, $styles);
	}

	add_action('buro_mikado_style_dynamic', 'buro_mikado_tabs_boxed_active_color_styles');
}