<?php

if(!function_exists('buro_mikado_tabs_map')) {
    function buro_mikado_tabs_map() {
		
        $panel = buro_mikado_add_admin_panel(array(
            'title' => esc_html__('Tabs', 'buro'),
            'name'  => 'panel_tabs',
            'page'  => '_elements_page'
        ));

        //Typography options
        buro_mikado_add_admin_section_title(array(
            'name' => 'typography_section_title',
            'title' => esc_html__('Tabs Navigation Typography', 'buro'),
            'parent' => $panel
        ));

        $typography_group = buro_mikado_add_admin_group(array(
            'name' => 'typography_group',
            'title' => esc_html__('Tabs Navigation Typography', 'buro'),
			'description' => esc_html__('Setup typography for tabs navigation', 'buro'),
            'parent' => $panel
        ));

        $typography_row = buro_mikado_add_admin_row(array(
            'name' => 'typography_row',
            'next' => true,
            'parent' => $typography_group
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $typography_row,
            'type'          => 'fontsimple',
            'name'          => 'tabs_font_family',
            'default_value' => '',
            'label'         => esc_html__('Font Family', 'buro'),
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $typography_row,
            'type'          => 'selectsimple',
            'name'          => 'tabs_text_transform',
            'default_value' => '',
            'label'         => esc_html__('Text Transform', 'buro'),
            'options'       => buro_mikado_get_text_transform_array()
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $typography_row,
            'type'          => 'selectsimple',
            'name'          => 'tabs_font_style',
            'default_value' => '',
            'label'         => esc_html__('Font Style', 'buro'),
            'options'       => buro_mikado_get_font_style_array()
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $typography_row,
            'type'          => 'textsimple',
            'name'          => 'tabs_letter_spacing',
            'default_value' => '',
            'label'         => esc_html__('Letter Spacing', 'buro'),
            'args'          => array(
                'suffix' => 'px'
            )
        ));

        $typography_row2 = buro_mikado_add_admin_row(array(
            'name' => 'typography_row2',
            'next' => true,
            'parent' => $typography_group
        ));		
		
        buro_mikado_add_admin_field(array(
            'parent'        => $typography_row2,
            'type'          => 'selectsimple',
            'name'          => 'tabs_font_weight',
            'default_value' => '',
            'label'         => esc_html__('Font Weight', 'buro'),
            'options'       => buro_mikado_get_font_weight_array()
        ));
		
		//Initial Tab Color Styles
		
		buro_mikado_add_admin_section_title(array(
            'name' => 'tab_color_section_title',
            'title' => esc_html__('Tab Navigation Color Styles', 'buro'),
            'parent' => $panel
        ));
		$tabs_color_group = buro_mikado_add_admin_group(array(
            'name' => 'tabs_color_group',
            'title' => esc_html__('Navigation Color Styles', 'buro'),
			'description' => esc_html__('Set color styles for tab navigation', 'buro'),
            'parent' => $panel
        ));
		$tabs_color_row = buro_mikado_add_admin_row(array(
            'name' => 'tabs_color_row',
            'next' => true,
            'parent' => $tabs_color_group
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'tabs_color',
            'default_value' => '',
            'label'         => esc_html__('Color', 'buro'),
        ));

		buro_mikado_add_admin_field(array(
            'parent'        => $tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'tabs_border_color',
            'default_value' => '',
            'label'         => esc_html__('Border Color', 'buro'),
        ));
		
		//Active Tab Color Styles
		
		$active_tabs_color_group = buro_mikado_add_admin_group(array(
            'name' => 'active_tabs_color_group',
            'title' => esc_html__('Active and Hover Navigation Color Styles', 'buro'),
			'description' => esc_html__('Set color styles for active and hover tabs', 'buro'),
            'parent' => $panel
        ));
		$active_tabs_color_row = buro_mikado_add_admin_row(array(
            'name' => 'active_tabs_color_row',
            'next' => true,
            'parent' => $active_tabs_color_group
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $active_tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'tabs_color_active',
            'default_value' => '',
            'label'         => esc_html__('Color', 'buro'),
        ));

		buro_mikado_add_admin_field(array(
            'parent'        => $active_tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'tabs_border_color_active',
            'default_value' => '',
            'label'         => esc_html__('Border Color', 'buro'),
        ));


        //Initial Boxed Tab Color Styles
		
		buro_mikado_add_admin_section_title(array(
            'name' => 'boxed_tab_color_section_title',
            'title' => esc_html__('Boxed Tab Navigation Color Styles', 'buro'),
            'parent' => $panel
        ));
		$boxed_tabs_color_group = buro_mikado_add_admin_group(array(
            'name' => 'boxed_tabs_color_group',
            'title' => esc_html__('Navigation Color Styles', 'buro'),
			'description' => esc_html__('Set color styles for tab navigation', 'buro'),
            'parent' => $panel
        ));
		$boxed_tabs_color_row = buro_mikado_add_admin_row(array(
            'name' => 'boxed_tabs_color_row',
            'next' => true,
            'parent' => $boxed_tabs_color_group
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $boxed_tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'boxed_tabs_color',
            'default_value' => '',
            'label'         => esc_html__('Color', 'buro'),
        ));
		buro_mikado_add_admin_field(array(
            'parent'        => $boxed_tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'boxed_tabs_back_color',
            'default_value' => '',
            'label'         => esc_html__('Background Color', 'buro'),
        ));
		
		//Active Boxed Tab Color Styles
		
		$active_boxed_tabs_color_group = buro_mikado_add_admin_group(array(
            'name' => 'active_boxed_tabs_color_group',
            'title' => esc_html__('Active and Hover Navigation Color Styles', 'buro'),
			'description' => esc_html__('Set color styles for active and hover tabs', 'buro'),
            'parent' => $panel
        ));

		$active_boxed_tabs_color_row = buro_mikado_add_admin_row(array(
            'name' => 'active_boxed_tabs_color_row',
            'next' => true,
            'parent' => $active_boxed_tabs_color_group
        ));

        buro_mikado_add_admin_field(array(
            'parent'        => $active_boxed_tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'boxed_tabs_color_active',
            'default_value' => '',
            'label'         => esc_html__('Color', 'buro'),
        ));

		buro_mikado_add_admin_field(array(
            'parent'        => $active_boxed_tabs_color_row,
            'type'          => 'colorsimple',
            'name'          => 'boxed_tabs_back_color_active',
            'default_value' => '',
            'label'         => esc_html__('Background Color', 'buro'),
        ));
    }

    add_action('buro_mikado_options_elements_map', 'buro_mikado_tabs_map');
}