<?php

class BuroMikadoSideAreaOpener extends BuroMikadoWidget {
    public function __construct() {
        parent::__construct(
            'mkd_side_area_opener', // Base ID
            esc_html__('Mikado Side Area Opener','mikado-core') // Name
        );

        $this->setParams();
    }

    protected function setParams() {

		$this->params = array(
			array(
				'name'			=> 'side_area_opener_icon_color',
				'type'			=> 'textfield',
				'title'			=> esc_html__('Icon Color', 'mikado-core'),
				'description'	=> esc_html__('Define color for Side Area opener icon', 'mikado-core'),
			)
		);

    }


    public function widget($args, $instance) {
		
		$sidearea_icon_styles = array();

		if ( !empty($instance['side_area_opener_icon_color']) ) {
			$sidearea_icon_styles[] = 'color: ' . $instance['side_area_opener_icon_color'];
		}
		
		$icon_size = '';
		if ( buro_mikado_options()->getOptionValue('side_area_predefined_icon_size') ) {
			$icon_size = buro_mikado_options()->getOptionValue('side_area_predefined_icon_size');
		}
		?>

        <?php print buro_mikado_display_content_output($args['before_widget']); ?>

        <a class="mkd-side-menu-button-opener <?php echo esc_attr( $icon_size ); ?>" <?php buro_mikado_inline_style($sidearea_icon_styles) ?> href="javascript:void(0)">
            <?php echo buro_mikado_get_side_menu_icon_html(); ?>
        </a>

        <?php print buro_mikado_display_content_output($args['after_widget']); ?>

    <?php }

}